<?php
// File: /client/manage-server.php
session_start();
if (!isset($_SESSION['has_logged']) || !$_SESSION['has_logged']) {
    header('Location: login.php');
    exit;
}
require_once '../config-server.php';
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Manage Requests | <?php echo $BASE_NAME; ?></title>
<?php include('../css.php'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container-xxl py-5">
  <h3 class="mb-4">Recent Upload Requests</h3>
  <div class="table-responsive">
    <table class="table table-bordered table-hover align-middle" id="requestTable">
      <thead>
        <tr>
          <th>#</th>
          <th>Username</th>
          <th>Source File</th>
          <th>SQL File</th>
          <th>Detail</th>
          <th>Request On</th>
          <th>Status</th>
          <th>Link</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>
<?php include('../js.php'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', async () => {
  const tbody = document.querySelector('#requestTable tbody');

  try {
    const res = await fetch('/home/includes/models/manage-server.php');
    const data = await res.json();

    if (data.status === 'success') {
      tbody.innerHTML = '';
      let i = 1;
      data.data.forEach(row => {
        const sourceName = row.source_path ? row.source_path.split('/').pop() : '';
        const sqlName = row.sql_path ? row.sql_path.split('/').pop() : '';
        const linkCell = row.status === 'success' && row.link
                         ? `<a href="${row.link}" target="_blank" class="btn btn-sm btn-primary">Download</a>`
                         : '';
        tbody.innerHTML += `<tr>
          <td>${i++}</td>
          <td>${row.username}</td>
          <td>${sourceName}</td>
          <td>${sqlName}</td>
          <td>${row.detail}</td>
          <td>${row.request_on}</td>
          <td>${row.status}</td>
          <td>${linkCell}</td>
        </tr>`;
      });
    } else if (data.status === 'not_logged') {
      Swal.fire({ icon: 'warning', title: 'Not Logged In', text: data.message }).then(() => window.location.href='login.php');
    } else {
      Swal.fire({ icon: 'error', title: 'Error', text: data.message });
    }
  } catch (err) {
    Swal.fire({ icon: 'error', title: 'Server Error', text: 'Unable to fetch requests' });
  }
});
</script>
</body>
</html>