<?php include '../config-server.php'; ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Upload Request | <?php echo $BASE_NAME; ?></title>
<?php include('../css.php'); ?>
</head>
<body>
<div class="container-xxl">
  <div class="authentication-wrapper container-p-y">
    <div class="authentication-inner py-6">
      <div class="card">
        <div class="card-body">
          <h4 class="mb-3">Submit Your Request</h4>
          <form id="requestForm" enctype="multipart/form-data">
            <div class="mb-3">
              <label class="form-label">Source File</label>
              <input type="file" class="form-control" id="source_file" name="source_file" required>
            </div>
            <div class="mb-3">
              <label class="form-label">SQL File</label>
              <input type="file" class="form-control" id="sql_file" name="sql_file" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Detail</label>
              <textarea class="form-control" id="detail" name="detail" placeholder="Enter details" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary d-grid w-100">Submit</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include('../js.php'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('requestForm');

  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    const formData = new FormData(form);

    try {
      const response = await fetch('/home/includes/models/request-server.php', {
        method: 'POST',
        body: formData
      });
      const data = await response.json();

      if(data.status === 'success'){
        Swal.fire({ icon: 'success', title: 'Success', text: data.message });
        form.reset();
      } else if(data.status === 'not_logged'){
        Swal.fire({ icon: 'warning', title: 'Not Logged In', text: data.message });
      } else {
        Swal.fire({ icon: 'error', title: 'Error', text: data.message });
      }
    } catch(err){
      Swal.fire({ icon: 'error', title: 'Server Error', text: 'Unable to connect to server' });
    }
  });
});
</script>
</body>
</html>