<?php
// File: /home/includes/models/login.php
session_start();
header('Content-Type: application/json');
require_once '../config-server.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}

$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';

if ($username === '' || $password === '') {
    echo json_encode(['status' => 'error', 'message' => 'Username or password missing']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT username,password,status,verified FROM USERS WHERE username = :u OR email = :u LIMIT 1");
    $stmt->execute(['u' => $username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || !password_verify($password, $user['password'])) {
        echo json_encode(['status' => 'invalid', 'message' => 'Username or password incorrect']);
        exit;
    }

    if ($user['status'] !== 'active') {
        echo json_encode(['status' => 'banned', 'message' => 'Your account is banned']);
        exit;
    }

    if (!$user['verified']) {
        echo json_encode(['status' => 'unverified', 'message' => 'Email is not verified']);
        exit;
    }

    $_SESSION['has_logged'] = true;
    $_SESSION['username'] = $user['username'];

    echo json_encode(['status' => 'success', 'message' => 'Login successful']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error']);
}