<?php
// File: /admin/handlers/delete-request.php
session_start();
header('Content-Type: application/json');
require_once '../../config-server.php';

if(!isset($_SESSION['admin_logged']) || $_SESSION['admin_logged'] !== true){
    echo json_encode(['status'=>'not_logged', 'message'=>'Admin not logged in']);
    exit;
}

$id = $_POST['id'] ?? '';
if(!$id){
    echo json_encode(['status'=>'error','message'=>'Invalid request ID']);
    exit;
}

try{
    $stmt = $pdo->prepare("DELETE FROM REQUEST WHERE id = :id");
    $stmt->execute(['id'=>$id]);
    echo json_encode(['status'=>'success','message'=>'Request deleted successfully']);
}catch(Exception $e){
    echo json_encode(['status'=>'error','message'=>'Failed to delete request']);
}