<?php
// File: /home/includes/models/request-upload.php
session_start();
header('Content-Type: application/json');
require_once '../config-server.php';

if (!isset($_SESSION['has_logged']) || !$_SESSION['has_logged']) {
    echo json_encode(['status' => 'not_logged', 'message' => 'User not logged in']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
    exit;
}

$username = $_SESSION['username'];
$detail = trim($_POST['detail'] ?? '');
$uploadDir = '/home/uploads/';

// Check files
if (!isset($_FILES['source_file']) || !isset($_FILES['sql_file'])) {
    echo json_encode(['status' => 'error', 'message' => 'Files not uploaded']);
    exit;
}

$sourceFile = $_FILES['source_file'];
$sqlFile = $_FILES['sql_file'];

$sourcePath = $uploadDir . basename($sourceFile['name']);
$sqlPath = $uploadDir . basename($sqlFile['name']);

// Move uploaded files
if (!move_uploaded_file($sourceFile['tmp_name'], $sourcePath)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to upload source file']);
    exit;
}
if (!move_uploaded_file($sqlFile['tmp_name'], $sqlPath)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to upload SQL file']);
    exit;
}

// Insert into database (example table: user_requests)
try {
    $stmt = $pdo->prepare("INSERT INTO user_requests (username, source_path, sql_path, request_on, status, detail) VALUES (:username, :source, :sql, NOW(), 'pending', :detail)");
    $stmt->execute([
        'username' => $username,
        'source' => $sourcePath,
        'sql' => $sqlPath,
        'detail' => $detail
    ]);
    echo json_encode(['status' => 'success', 'message' => 'Request successfully submitted']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to submit request']);
}