<?php include '../config-server.php'; ?>
<!doctype html>
<html lang="en" class="layout-wide customizer-hide" dir="ltr" data-skin="default" data-bs-theme="light" data-assets-path="http://anupam777.us.cc/assets/" data-template="vertical-menu-template">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
<meta name="robots" content="noindex, nofollow">
<title>Login | <?php echo $BASE_NAME; ?></title>
<meta name="description" content="">
<?php include('../css.php'); ?>
</head>
<body>
<div class="container-xxl">
  <div class="authentication-wrapper authentication-basic container-p-y">
    <div class="authentication-inner py-6">
      <div class="card">
        <div class="card-body">
          <div class="app-brand justify-content-center mb-6">
            <a href="index.html" class="app-brand-link">
              <span class="app-brand-logo demo">
                <span class="text-primary">
                  <svg width="32" height="22" viewBox="0 0 32 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M0.00172773 0V6.85398S-0.133178 9.01207 1.98092 10.8388L13.6912 21.9964L19.7809 21.9181L18.8042 9.88248L16.4951 7.17289L9.23799 0H0.00172773Z" fill="currentColor"/>
                    <path opacity="0.06" fill-rule="evenodd" clip-rule="evenodd" d="M7.69824 16.4364L12.5199 3.23696L16.5541 7.25596L7.69824 16.4364Z" fill="#161616"/>
                    <path opacity="0.06" fill-rule="evenodd" clip-rule="evenodd" d="M8.07751 15.9175L13.9419 4.63989L16.5849 7.28475L8.07751 15.9175Z" fill="#161616"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.77295 16.3566L23.6563 0H32V6.88383S31.8262 9.17836 30.6591 10.4057L19.7824 22H13.6938L7.77295 16.3566Z" fill="currentColor"/>
                  </svg>
                </span>
              </span>
              <span class="app-brand-text demo text-heading fw-bold">Vuexy</span>
            </a>
          </div>
          <h4 class="mb-1">Welcome to <?php echo $BASE_NAME; ?>! 👋</h4>
          <p class="mb-6">Please sign-in to your account and start the adventure</p>
          <form id="formAuthentication" class="mb-4" method="POST">
            <div class="mb-6 form-control-validation">
              <label for="email" class="form-label">Email or Username</label>
              <input type="text" class="form-control" id="email" name="email-username" placeholder="Enter your email or username" autofocus>
            </div>
            <div class="mb-6 form-password-toggle form-control-validation">
              <label class="form-label" for="password">Password</label>
              <div class="input-group input-group-merge">
                <input type="password" id="password" class="form-control" name="password" placeholder="••••••••••••" aria-describedby="password">
                <span class="input-group-text cursor-pointer"><i class="icon-base ti tabler-eye-off"></i></span>
              </div>
            </div>
            <div class="my-8 d-flex justify-content-between">
              <div class="form-check mb-0 ms-2">
                <input class="form-check-input" type="checkbox" id="remember-me">
                <label class="form-check-label" for="remember-me">Remember Me</label>
              </div>
            </div>
            <div class="mb-6">
              <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
            </div>
          </form>
          <p class="text-center">
            <span>New on our platform?</span>
            <a href="auth-register-basic.html"><span>Create an account</span></a>
          </p>
          <div class="divider my-6"><div class="divider-text">or</div></div>
          <div class="d-flex justify-content-center">
            <a href="javascript:;" class="btn btn-icon rounded-circle btn-text-facebook me-1_5"><i class="icon-base ti tabler-brand-facebook-filled icon-20px"></i></a>
            <a href="javascript:;" class="btn btn-icon rounded-circle btn-text-twitter me-1_5"><i class="icon-base ti tabler-brand-twitter-filled icon-20px"></i></a>
            <a href="javascript:;" class="btn btn-icon rounded-circle btn-text-github me-1_5"><i class="icon-base ti tabler-brand-github-filled icon-20px"></i></a>
            <a href="javascript:;" class="btn btn-icon rounded-circle btn-text-google-plus"><i class="icon-base ti tabler-brand-google-filled icon-20px"></i></a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include('../js.php'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('formAuthentication');
  const toggle = document.querySelector('.form-password-toggle .input-group-text i');

  if(toggle){
    toggle.addEventListener('click', () => {
      const pwd = document.getElementById('password');
      if(pwd.type === 'password'){
        pwd.type = 'text';
        toggle.classList.remove('tabler-eye-off');
        toggle.classList.add('tabler-eye');
      } else {
        pwd.type = 'password';
        toggle.classList.remove('tabler-eye');
        toggle.classList.add('tabler-eye-off');
      }
    });
  }

  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    const username = document.getElementById('email').value.trim();
    const password = document.getElementById('password').value;

    if(!username || !password){
      Swal.fire({ icon: 'warning', title: 'Missing Fields', text: 'Please enter username and password' });
      return;
    }

    try{
      const response = await fetch('/home/includes/models/login.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({ username: username, password: password })
      });
      const data = await response.json();

      if(data.status === 'success'){
        Swal.fire({ icon: 'success', title: 'Login Successful', text: data.message, timer:1500, showConfirmButton:false })
        .then(() => window.location.href='/client/index.php');
      }
      else if(data.status === 'banned'){
        Swal.fire({ icon: 'error', title: 'Account Banned', text: data.message });
      }
      else if(data.status === 'unverified'){
        Swal.fire({ icon: 'info', title: 'Email Not Verified', text: data.message });
      }
      else if(data.status === 'invalid'){
        Swal.fire({ icon: 'error', title: 'Login Failed', text: data.message });
      }
      else{
        Swal.fire({ icon: 'error', title: 'Error', text: 'Something went wrong' });
      }
    }catch(err){
      Swal.fire({ icon: 'error', title: 'Server Error', text: 'Unable to connect to server' });
    }
  });
});
</script>
</body>
</html>