<?php
// File: /admin/manage-pending.php
session_start();
if (!isset($_SESSION['admin_logged']) || $_SESSION['admin_logged'] !== true) {
    header('Location: login.php');
    exit;
}
require_once '../config-server.php';
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin - Pending Requests | <?php echo $BASE_NAME; ?></title>
<?php include('../css.php'); ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>
<body>
<div class="container-xxl py-5">
  <h3 class="mb-4">Pending Requests</h3>
  <div class="table-responsive">
    <table class="table table-bordered table-hover align-middle" id="pendingTable">
      <thead>
        <tr>
          <th>Username</th>
          <th>Source Path</th>
          <th>SQL Path</th>
          <th>Detail</th>
          <th>Request On</th>
          <th>Status</th>
          <th>Link</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php
        try {
            $stmt = $pdo->query("SELECT * FROM REQUEST WHERE status='pending' ORDER BY request_on DESC");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<tr data-id='{$row['id']}'>
                    <td>{$row['username']}</td>
                    <td>{$row['source_path']}</td>
                    <td>{$row['sql_path']}</td>
                    <td>".htmlspecialchars($row['detail'])."</td>
                    <td>{$row['request_on']}</td>
                    <td>{$row['status']}</td>
                    <td>{$row['link']}</td>
                    <td>
                      <button class='btn btn-sm btn-success approve-btn'>Approve</button>
                      <button class='btn btn-sm btn-warning deny-btn'>Deny</button>
                      <button class='btn btn-sm btn-danger delete-btn'>Delete</button>
                    </td>
                </tr>";
            }
        } catch(Exception $e){
            echo "<tr><td colspan='8'>Failed to fetch requests</td></tr>";
        }
        ?>
      </tbody>
    </table>
  </div>
</div>

<?php include('../js.php'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const table = document.getElementById('pendingTable');

    table.addEventListener('click', async (e) => {
        const row = e.target.closest('tr');
        if (!row) return;
        const id = row.dataset.id;

        // Approve
        if(e.target.classList.contains('approve-btn')){
            const { value: link } = await Swal.fire({
                title: 'Enter link for client',
                input: 'text',
                inputLabel: 'Link',
                inputPlaceholder: 'Enter the link',
                showCancelButton: true
            });
            if(link){
                try {
                    const res = await fetch('/admin/handlers/approve-request.php', {
                        method: 'POST',
                        headers: {'Content-Type':'application/x-www-form-urlencoded'},
                        body: `id=${id}&link=${encodeURIComponent(link)}`
                    });
                    const data = await res.json();
                    if(data.status === 'success'){
                        Swal.fire('Approved!', data.message, 'success').then(()=> location.reload());
                    } else {
                        Swal.fire('Error', data.message, 'error');
                    }
                } catch(err){
                    Swal.fire('Error', 'Server error', 'error');
                }
            }
        }

        // Deny
        if(e.target.classList.contains('deny-btn')){
            Swal.fire({
                title: 'Deny this request?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, deny it'
            }).then(async (result) => {
                if(result.isConfirmed){
                    try {
                        const res = await fetch('/admin/handlers/deny-request.php', {
                            method: 'POST',
                            headers: {'Content-Type':'application/x-www-form-urlencoded'},
                            body: `id=${id}`
                        });
                        const data = await res.json();
                        if(data.status === 'success'){
                            Swal.fire('Denied!', data.message, 'success').then(()=> location.reload());
                        } else {
                            Swal.fire('Error', data.message, 'error');
                        }
                    } catch(err){
                        Swal.fire('Error', 'Server error', 'error');
                    }
                }
            });
        }

        // Delete
        if(e.target.classList.contains('delete-btn')){
            Swal.fire({
                title: 'Are you sure?',
                text: 'This request will be deleted permanently!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!'
            }).then(async (result) => {
                if(result.isConfirmed){
                    try {
                        const res = await fetch('/admin/handlers/delete-request.php', {
                            method: 'POST',
                            headers: {'Content-Type':'application/x-www-form-urlencoded'},
                            body: `id=${id}`
                        });
                        const data = await res.json();
                        if(data.status === 'success'){
                            Swal.fire('Deleted!', data.message, 'success').then(()=> location.reload());
                        } else {
                            Swal.fire('Error', data.message, 'error');
                        }
                    } catch(err){
                        Swal.fire('Error', 'Server error', 'error');
                    }
                }
            });
        }
    });
});
</script>
<?php include('../js.php'); ?>
</body>
</html>